'/***************************************************************************/
'/**                                                                       **/
'/**                               MAGICARD                                **/
'/**                                                                       **/
'/***************************************************************************/
'/**                                                                       **/
'/**  PROJECT      : SDK VB Demo - DTC Printers                            **/
'/**                                                                       **/
'/**  MODULE NAME  : Driver1.vb                                            **/
'/**                                                                       **/
'/**  COPYRIGHT    : Magicard                                              **/
'/**                                                                       **/
'/***************************************************************************/
Partial Public Class Main

#Region "=== Initialisation ==="

    Private Sub InitDriver1Tab()
        InitCorrectionCombos()
        InitPrintSpeedCombo()
        InitSideCombos()
        InitAreaHoleCombo()
    End Sub

    Private sidekp As New Dictionary(Of SDK.Side, String) From
    {
        {SDK.Side.Front, "Front"},
        {SDK.Side.Back, "Back"}
    }

    Private Sub InitSideCombos()
        ResinAreaSideCombo.DataSource = New BindingSource(sidekp, Nothing)
        ResinAreaSideCombo.DisplayMember = "Value"
        ResinAreaSideCombo.ValueMember = "Key"

        AreaHoleSideCombo.DataSource = New BindingSource(sidekp, Nothing)
        AreaHoleSideCombo.DisplayMember = "Value"
        AreaHoleSideCombo.ValueMember = "Key"

        CardSettingsSideCombo.DataSource = New BindingSource(sidekp, Nothing)
        CardSettingsSideCombo.DisplayMember = "Value"
        CardSettingsSideCombo.ValueMember = "Key"

        HoloKoteSideCombo.DataSource = New BindingSource(sidekp, Nothing)
        HoloKoteSideCombo.DisplayMember = "Value"
        HoloKoteSideCombo.ValueMember = "Key"

        ColourAreaSideCombo.DataSource = New BindingSource(sidekp, Nothing)
        ColourAreaSideCombo.DisplayMember = "Value"
        ColourAreaSideCombo.ValueMember = "Key"
    End Sub

    Private areaholekp As New Dictionary(Of SDK.AreaHole, String) From
    {
        {SDK.AreaHole.Area, "Area"},
        {SDK.AreaHole.Hole, "Hole"}
    }

    Private Sub InitAreaHoleCombo()
        AreaHoleTypeCombo.DataSource = New BindingSource(areaholekp, Nothing)
        AreaHoleTypeCombo.DisplayMember = "Value"
        AreaHoleTypeCombo.ValueMember = "Key"
    End Sub

#End Region

    '----------------------------------------------------------------------

#Region "=== Local Methods ==="

    Private Sub Driver1Controls(Control As Boolean)
        If Driver1TabInit = True Then
            GUIUserCheck.Enabled = Control
            GUIPrinterCheck.Enabled = Control
            SharpnessUpDown.Enabled = Control
            CorrectionCombo.Enabled = Control
            YMCPowerUpDown.Enabled = Control
            ResinPowerUpDown.Enabled = Control
            OvercoatPowerUpDown.Enabled = Control
            ResinAreaLeftUpDown.Enabled = Control
            ResinAreaWidthUpDown.Enabled = Control
            ResinAreaBottomUpDown.Enabled = Control
            ResinAreaHeightUpDown.Enabled = Control
            AreaHoleLeftUpDown.Enabled = Control
            AreaHoleWidthUpDown.Enabled = Control
            AreaHoleBottomUpDown.Enabled = Control
            AreaHoleHeightUpDown.Enabled = Control
            EraseAreaLeftUpDown.Enabled = Control
            EraseAreaWidthUpDown.Enabled = Control
            EraseAreaBottomUpDown.Enabled = Control
            EraseAreaHeightUpDown.Enabled = Control
            ErasePowerStartUpDown.Enabled = Control
            ErasePowerEndUpDown.Enabled = Control
            WritePowerUpDown.Enabled = Control
            EraseBeforePrint.Enabled = Control

            Select Case printerType
                Case SDK.PrinterType.Enduro
                    PrintSpeedCombo.Enabled = Control
                Case SDK.PrinterType.Generation2
                    PrintableAreaLeftUpDown.Enabled = Control
                    PrintableAreaWidthUpDown.Enabled = Control
                    PrintableAreaBottomUpDown.Enabled = Control
                    PrintableAreaHeightUpDown.Enabled = Control
                    If PrinterIs600DPICapable() Then
                        Radio300DPI.Enabled = Control
                        Radio600DPI.Enabled = Control
                    End If
            End Select
        End If

    End Sub

    Private Function PrinterIs600DPICapable() As Boolean
        If printerType <> SDK.PrinterType.Generation2 Then
            Return False
        End If

        Return SDK.ID_PrinterModel(hSession).HasFlag(SDK.Model.Fn_600dpi)
    End Function

    Private Function Driver1ActionIsGet() As Boolean
        Return Driver1GetRadio.Checked
    End Function

    Private Sub ClearDriver1MsgBoxButton_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) _
                Handles ClearDriver1MsgBoxButton.Click
        Driver1MsgBox.Clear()
    End Sub

    Private Sub Driver1ActionGetRadio_CheckedChanged(ByVal sender As System.Object, ByVal e As System.EventArgs) _
                Handles Driver1GetRadio.CheckedChanged
        Driver1Controls(False)
    End Sub

    Private Sub Driver1ActionSetRadio_CheckedChanged(ByVal sender As System.Object, ByVal e As System.EventArgs) _
                Handles Driver1SetRadio.CheckedChanged
        Driver1Controls(True)
    End Sub

#End Region

    '----------------------------------------------------------------------

#Region "=== GUI Control ==="

    Private Sub GUIControlToMsgBox(ByVal Action As SDK.Action, ByVal control As SDK.GUIControl)
        Dim sep As String = Separator(Action)
        Driver1MsgBox.AppendText("GUI User" + sep + control.User.ToString + Environment.NewLine)
        Driver1MsgBox.AppendText("GUI Printer" + sep + control.Printer.ToString + Environment.NewLine)
        Driver1MsgBox.AppendText(Environment.NewLine)
    End Sub

    Private Sub SetGUIControl(ByVal control As SDK.GUIControl)
        GUIUserCheck.Checked = control.User
        GUIPrinterCheck.Checked = control.Printer
    End Sub

    Private Function GetGUIControl(ByRef control As SDK.GUIControl) As SDK.Return
        Dim SDKReturn As SDK.Return = SDK.ID_GUIControl(hSession, SDK.Action.Read, control)
        If SDKReturn = SDK.Return.Success Then
            SetGUIControl(control)
        Else
            HandleError("GetGUIControl", SDKReturn)
        End If

        Return SDKReturn
    End Function

    Private Sub GUIControlButton_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) _
                Handles GUIControlButton.Click
        Dim control As SDK.GUIControl = New SDK.GUIControl

        If Driver1ActionIsGet() Then
            If GetGUIControl(control) = SDK.Return.Success Then
                GUIControlToMsgBox(SDK.Action.Read, control)
            End If
        Else
            control.User = GUIUserCheck.Checked()
            control.Printer = GUIPrinterCheck.Checked
            Dim SDKReturn As SDK.Return = SDK.ID_GUIControl(hSession, SDK.Action.Write, control)
            If SDKReturn <> SDK.Return.Success Then
                HandleError("SetGUIControl", SDKReturn)
            Else
                GUIControlToMsgBox(SDK.Action.Write, control)
            End If
        End If
    End Sub

#End Region

    '----------------------------------------------------------------------

#Region "=== Sharpness ==="

    Private Function GetSharpness(ByRef sharpness As SByte) As SDK.Return
        Dim SDKReturn As SDK.Return = SDK.ID_Sharpness(hSession, SDK.Action.Read, sharpness)
        If SDKReturn = SDK.Return.Success Then
            SetSharpness(sharpness)
        Else
            HandleError("GetSharpness", SDKReturn)
        End If

        Return SDKReturn
    End Function

    Private Sub SharpnessToMsgBox(ByVal Action As SDK.Action, ByVal sharpness As SByte)
        Dim sep As String = Separator(Action)
        Driver1MsgBox.AppendText("Sharpness" + sep + sharpness.ToString() + Environment.NewLine)
        Driver1MsgBox.AppendText(Environment.NewLine)
    End Sub

    Private Sub SetSharpness(ByVal sharpness As SByte)
        SharpnessUpDown.Value = sharpness
    End Sub

    Private Sub SharpnessButton_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) _
                Handles SharpnessButton.Click
        Dim sharpness As SByte = SharpnessUpDown.Value

        If Driver1ActionIsGet() Then
            If GetSharpness(sharpness) = SDK.Return.Success Then
                SharpnessToMsgBox(SDK.Action.Read, sharpness)
            End If
        Else
            Dim SDKReturn As SDK.Return = SDK.ID_Sharpness(hSession, SDK.Action.Write, sharpness)
            If SDKReturn <> SDK.Return.Success Then
                HandleError("SetSharpness", SDKReturn)
            Else
                SharpnessToMsgBox(SDK.Action.Write, sharpness)
            End If
        End If
    End Sub

#End Region

    '----------------------------------------------------------------------

#Region "=== Colour Correction ==="

    Private correctionkp As New Dictionary(Of SDK.Correction, String) From
    {
        {SDK.Correction.None, "None"},
        {SDK.Correction.Gamma1, "Gamma1"},
        {SDK.Correction.Gamma2, "Gamma2"},
        {SDK.Correction.ICC_Internal, "ICC Internal"},
        {SDK.Correction.ICC_External, "ICC External"},
        {SDK.Correction.Perceptual, "Perceptual"},
        {SDK.Correction.Saturation, "Saturation"},
        {SDK.Correction.RelColorimetric, "Rel Colorimetric"},
        {SDK.Correction.AbsColorimetric, "Abs Colorimetric"}
    }

    Private Sub InitCorrectionCombos()
        CorrectionCombo.DataSource = New BindingSource(correctionkp, Nothing)
        CorrectionCombo.DisplayMember = "Value"
        CorrectionCombo.ValueMember = "Key"
        ColourAreaCorrectionCombo.DataSource = New BindingSource(correctionkp, Nothing)
        ColourAreaCorrectionCombo.DisplayMember = "Value"
        ColourAreaCorrectionCombo.ValueMember = "Key"
    End Sub

    Private Sub CorrectionToMsgBox(ByVal Action As SDK.Action, ByVal correction As SDK.Correction)
        Dim sep As String = Separator(Action)
        Driver1MsgBox.AppendText("Colour Correction" + sep + correctionkp.Item(correction) + Environment.NewLine)
        Driver1MsgBox.AppendText(Environment.NewLine)
    End Sub

    Private Sub SetCorrection(ByVal correction As SDK.Correction)
        CorrectionCombo.Text = correctionkp.Item(correction)
    End Sub

    Private Function GetColourCorrection(ByRef correction As SDK.Correction) As SDK.Return
        Dim SDKReturn As SDK.Return = SDK.ID_ColourCorrection(hSession, SDK.Action.Read, correction)
        If SDKReturn = SDK.Return.Success Then
            SetCorrection(correction)
        Else
            HandleError("GetColourCorrection", SDKReturn)
        End If

        Return SDKReturn
    End Function

    Private Sub ColourCorrectionButton_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) _
                Handles ColourCorrectionButton.Click
        Dim correction As SDK.Correction = New SDK.Correction

        If Driver1ActionIsGet() Then
            If GetColourCorrection(correction) = SDK.Return.Success Then
                CorrectionToMsgBox(SDK.Action.Read, correction)
            End If
        Else
            correction = CorrectionCombo.SelectedItem.Key
            Dim SDKReturn As SDK.Return = SDK.ID_ColourCorrection(hSession, SDK.Action.Write, correction)
            If SDKReturn <> SDK.Return.Success Then
                HandleError("SetColourCorrection", SDKReturn)
            Else
                CorrectionToMsgBox(SDK.Action.Write, correction)
            End If
        End If
    End Sub

#End Region

    '----------------------------------------------------------------------

#Region "=== Print Speed ==="

    Private printspeedkp As New Dictionary(Of SDK.PrintSpeed, String) From
    {
        {SDK.PrintSpeed.Normal, "Normal"},
        {SDK.PrintSpeed.High, "High"}
    }

    Private Sub InitPrintSpeedCombo()
        PrintSpeedCombo.DataSource = New BindingSource(printspeedkp, Nothing)
        PrintSpeedCombo.DisplayMember = "Value"
        PrintSpeedCombo.ValueMember = "Key"
    End Sub

    Private Sub PrintSpeedToMsgBox(ByVal Action As SDK.Action, ByVal speed As SDK.PrintSpeed)
        Dim sep As String = Separator(Action)
        Driver1MsgBox.AppendText("Print Speed" + sep + printspeedkp.Item(speed) + Environment.NewLine)
        Driver1MsgBox.AppendText(Environment.NewLine)
    End Sub

    Private Sub SetPrintSpeedBox(ByVal speed As SDK.PrintSpeed)
        PrintSpeedCombo.Text = printspeedkp.Item(speed)
    End Sub

    Private Function GetPrintSpeed(ByRef speed As SDK.PrintSpeed) As SDK.Return
        Dim SDKReturn As SDK.Return

        SDKReturn = SDK.ID_PrintSpeed(hSession, SDK.Action.Read, speed)
        If SDKReturn = SDK.Return.Success Then
            SetPrintSpeedBox(speed)
        Else
            HandleError("GetPrintSpeed", SDKReturn)
        End If

        Return SDKReturn
    End Function

    Private Sub PrintSpeedButton_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) _
                Handles PrintSpeedButton.Click
        Dim speed As SDK.PrintSpeed = PrintSpeedCombo.SelectedItem.Key
        Dim SDKReturn As SDK.Return

        If Driver1ActionIsGet() Then
            If GetPrintSpeed(speed) = SDK.Return.Success Then
                PrintSpeedToMsgBox(SDK.Action.Read, speed)
            End If
        Else
            SDKReturn = SDK.ID_PrintSpeed(hSession, SDK.Action.Write, speed)
            If SDKReturn <> SDK.Return.Success Then
                HandleError("SetPrintSpeed", SDKReturn)
            Else
                PrintSpeedToMsgBox(SDK.Action.Write, speed)
            End If
        End If
    End Sub

#End Region

    '----------------------------------------------------------------------

#Region "=== Power Levels ==="

    Private Function GetPowerLevels(ByRef Levels As SDK.PowerLevel) As SDK.Return
        Dim SDKReturn As SDK.Return = SDK.ID_PowerLevel(hSession, SDK.Action.Read, Levels)
        If SDKReturn = SDK.Return.Success Then
            SetPowerLevels(Levels)
        Else
            HandleError("GetPowerLevel", SDKReturn)
        End If

        Return SDKReturn
    End Function

    Private Sub PowerLevelsToMsgBox(ByVal Action As SDK.Action, ByVal PowerLevel As SDK.PowerLevel)
        Dim sep As String = Separator(Action)
        Driver1MsgBox.AppendText("Power Level YMC" + sep + PowerLevel.YMC.ToString() + Environment.NewLine)
        Driver1MsgBox.AppendText("Power Level Resin" + sep + PowerLevel.Resin.ToString() + Environment.NewLine)
        Driver1MsgBox.AppendText("Power Level Overcoat" + sep + PowerLevel.Overcoat.ToString() + Environment.NewLine)
        Driver1MsgBox.AppendText(Environment.NewLine)
    End Sub

    Private Sub SetPowerLevels(ByVal PowerLevel As SDK.PowerLevel)
        YMCPowerUpDown.Value = PowerLevel.YMC
        ResinPowerUpDown.Value = PowerLevel.Resin
        OvercoatPowerUpDown.Value = PowerLevel.Overcoat
    End Sub

    Private Sub PowerLevelButton_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) _
                Handles PowerLevelButton.Click
        Dim PowerLevel As New SDK.PowerLevel

        If Driver1ActionIsGet() Then
            If GetPowerLevels(PowerLevel) = SDK.Return.Success Then
                PowerLevelsToMsgBox(SDK.Action.Read, PowerLevel)
            End If
        Else
            PowerLevel.YMC = YMCPowerUpDown.Value
            PowerLevel.Resin = ResinPowerUpDown.Value
            PowerLevel.Overcoat = OvercoatPowerUpDown.Value

            Dim SDKReturn As SDK.Return = SDK.ID_PowerLevel(hSession, SDK.Action.Write, PowerLevel)
            If SDKReturn <> SDK.Return.Success Then
                HandleError("SetPowerLevel", SDKReturn)
            Else
                PowerLevelsToMsgBox(SDK.Action.Write, PowerLevel)
            End If
        End If
    End Sub

#End Region

    '----------------------------------------------------------------------

#Region "=== Resin Areas ==="

    Private Sub ResinArea_Changed(ByVal sender As System.Object, ByVal e As System.EventArgs) _
                Handles ResinAreaSideCombo.SelectedIndexChanged, _
                        ResinAreaNoUpDown.ValueChanged
        If Driver1TabInit Then
            Dim Area As New SDK.Area
            Dim SDKReturn As SDK.Return = GetResinArea(ResinAreaSideCombo.SelectedItem.Key, ResinAreaNoUpDown.Value, Area)
            If SDKReturn = SDK.Return.Success Then
                SetResinArea(Area)
            End If
        End If
    End Sub

    Private Function GetResinArea(ByVal SideID As SDK.Side, ByVal AreaNo As Byte, ByRef Area As SDK.Area) As SDK.Return
        Dim SDKReturn As SDK.Return = SDK.ID_ResinArea(hSession, SDK.Action.Read, SideID, AreaNo, Area)
        If SDKReturn = SDK.Return.Success Then
            SetResinArea(Area)
        Else
            HandleError("GetResinArea", SDKReturn)
        End If

        Return SDKReturn
    End Function

    Private Sub ResinAreaToMsgBox(ByVal Action As SDK.Action, ByVal side As SDK.Side, ByVal area As SDK.Area)
        Dim sep As String = Separator(Action)
        Driver1MsgBox.AppendText("Resin Area " + sidekp.Item(side) + " " + ResinAreaNoUpDown.Value.ToString() + Environment.NewLine)
        Driver1MsgBox.AppendText("Area Left" + sep + area.Left.ToString() + Environment.NewLine)
        Driver1MsgBox.AppendText("Area Width" + sep + area.Width.ToString() + Environment.NewLine)
        Driver1MsgBox.AppendText("Area Bottom" + sep + area.Bottom.ToString() + Environment.NewLine)
        Driver1MsgBox.AppendText("Area Height" + sep + area.Height.ToString() + Environment.NewLine)
        Driver1MsgBox.AppendText(Environment.NewLine)
    End Sub

    Private Sub SetResinArea(ByVal Area As SDK.Area)
        ResinAreaLeftUpDown.Value = Area.Left
        ResinAreaWidthUpDown.Value = Area.Width
        ResinAreaBottomUpDown.Value = Area.Bottom
        ResinAreaHeightUpDown.Value = Area.Height
    End Sub

    Private Sub ResinAreaButton_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) _
                Handles ResinAreaButton.Click
        Dim area As New SDK.Area
        Dim side As SDK.Side = ResinAreaSideCombo.SelectedItem.Key

        If Driver1ActionIsGet() Then
            If GetResinArea(side, ResinAreaNoUpDown.Value, area) = SDK.Return.Success Then
                ResinAreaToMsgBox(SDK.Action.Read, side, area)
            End If
        Else
            area.Left = ResinAreaLeftUpDown.Value
            area.Width = ResinAreaWidthUpDown.Value
            area.Bottom = ResinAreaBottomUpDown.Value
            area.Height = ResinAreaHeightUpDown.Value

            Dim SDKReturn As SDK.Return = SDK.ID_ResinArea(hSession, _
                                                           SDK.Action.Write, _
                                                           side, _
                                                           ResinAreaNoUpDown.Value, _
                                                           area)
            If SDKReturn <> SDK.Return.Success Then
                HandleError("SetResinArea", SDKReturn)
            Else
                ResinAreaToMsgBox(SDK.Action.Write, side, area)
            End If
        End If
    End Sub

#End Region

    '----------------------------------------------------------------------

#Region "=== Areas/Holes ==="

    Private Sub AreaHole_Changed(ByVal sender As System.Object, ByVal e As System.EventArgs) _
                Handles AreaHoleSideCombo.SelectedIndexChanged,
                        AreaHoleNoUpDown.ValueChanged,
                        AreaHoleTypeCombo.SelectedIndexChanged
        If Driver1TabInit Then
            Dim Area As New SDK.Area
            Dim SDKReturn As SDK.Return
            SDKReturn = GetAreaHole(AreaHoleSideCombo.SelectedItem.Key,
                                    AreaHoleTypeCombo.SelectedItem.Key,
                                    AreaHoleNoUpDown.Value,
                                    Area)
            If SDKReturn = SDK.Return.Success Then
                SetAreaHole(Area)
            End If
        End If
    End Sub

    Private Function GetAreaHole(ByVal SideID As SDK.Side, _
                                 ByVal AreaHoleID As SDK.AreaHole, _
                                 ByVal AreaNo As Byte, _
                                 ByRef Area As SDK.Area) As SDK.Return
        Dim SDKReturn As SDK.Return
        SDKReturn = SDK.ID_AreaHole(hSession,
                                    SDK.Action.Read,
                                    SideID,
                                    AreaHoleID,
                                    AreaNo,
                                    Area)
        If SDKReturn = SDK.Return.Success Then
            SetAreaHole(Area)
        Else
            HandleError("GetAreaHole", SDKReturn)
        End If

        Return SDKReturn
    End Function

    Private Sub AreaHoleToMsgBox(ByVal Action As SDK.Action, _
                                 ByVal side As SDK.Side, _
                                 ByVal type As SDK.AreaHole, _
                                 ByVal area As SDK.Area)
        Dim sep As String = Separator(Action)
        Driver1MsgBox.AppendText("Area/Hole " _
                                 + sidekp.Item(side) + " " _
                                 + areaholekp.Item(type) + " " _
                                 + AreaHoleNoUpDown.Value.ToString() + Environment.NewLine)
        Driver1MsgBox.AppendText("Area Left" + sep + area.Left.ToString() + Environment.NewLine)
        Driver1MsgBox.AppendText("Area Width" + sep + area.Width.ToString() + Environment.NewLine)
        Driver1MsgBox.AppendText("Area Bottom" + sep + area.Bottom.ToString() + Environment.NewLine)
        Driver1MsgBox.AppendText("Area Height" + sep + area.Height.ToString() + Environment.NewLine)
        Driver1MsgBox.AppendText(Environment.NewLine)
    End Sub

    Private Sub SetAreaHole(ByVal Area As SDK.Area)
        AreaHoleLeftUpDown.Value = Area.Left
        AreaHoleWidthUpDown.Value = Area.Width
        AreaHoleBottomUpDown.Value = Area.Bottom
        AreaHoleHeightUpDown.Value = Area.Height
    End Sub

    Private Sub AreaHoleButton_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) _
                Handles AreaHoleButton.Click
        Dim area As New SDK.Area
        Dim side As SDK.Side = AreaHoleSideCombo.SelectedItem.Key
        Dim type As SDK.AreaHole = AreaHoleTypeCombo.SelectedItem.Key
        Dim SDKReturn As SDK.Return

        If Driver1ActionIsGet() Then
            If GetAreaHole(side, type, AreaHoleNoUpDown.Value, area) = SDK.Return.Success Then
                AreaHoleToMsgBox(SDK.Action.Read, side, type, area)
            End If
        Else
            area.Left = AreaHoleLeftUpDown.Value
            area.Width = AreaHoleWidthUpDown.Value
            area.Bottom = AreaHoleBottomUpDown.Value
            area.Height = AreaHoleHeightUpDown.Value

            SDKReturn = SDK.ID_AreaHole(hSession,
                                                   SDK.Action.Write,
                                                   side,
                                                   type,
                                                   AreaHoleNoUpDown.Value,
                                                   area)
            If SDKReturn <> SDK.Return.Success Then
                HandleError("SetAreaHole", SDKReturn)
            Else
                AreaHoleToMsgBox(SDK.Action.Write, side, type, area)
            End If
        End If
    End Sub

#End Region

    '----------------------------------------------------------------------

#Region "=== Rewritable Cards ==="

    Private Function GetRewritable(ByRef rewritable As SDK.Rewritable) As SDK.Return
        Dim SDKReturn As SDK.Return

        SDKReturn = SDK.ID_Rewritable(hSession, SDK.Action.Read, rewritable)
        If SDKReturn = SDK.Return.Success Then
            SetRewritable(rewritable)
        Else
            HandleError("GetRewritable", SDKReturn)
        End If

        Return SDKReturn
    End Function

    Private Sub RewritableToMsgBox(ByVal Action As SDK.Action,
                                   ByVal rewritable As SDK.Rewritable)
        Dim sep As String = Separator(Action)
        Driver1MsgBox.AppendText("Rewritable" + Environment.NewLine)
        Driver1MsgBox.AppendText("Area Left" + sep + rewritable.EraseArea.Left.ToString() + Environment.NewLine)
        Driver1MsgBox.AppendText("Area Width" + sep + rewritable.EraseArea.Width.ToString() + Environment.NewLine)
        Driver1MsgBox.AppendText("Area Bottom" + sep + rewritable.EraseArea.Bottom.ToString() + Environment.NewLine)
        Driver1MsgBox.AppendText("Area Height" + sep + rewritable.EraseArea.Height.ToString() + Environment.NewLine)
        Driver1MsgBox.AppendText("Erase Before Print" + sep + rewritable.EraseBeforePrint.ToString() + Environment.NewLine)
        Driver1MsgBox.AppendText("Erase Power Start" + sep + rewritable.ErasePowerStart.ToString() + Environment.NewLine)
        Driver1MsgBox.AppendText("Erase Power End" + sep + rewritable.ErasePowerEnd.ToString() + Environment.NewLine)
        Driver1MsgBox.AppendText("Write Power" + sep + rewritable.WritePower.ToString() + Environment.NewLine)
        Driver1MsgBox.AppendText(Environment.NewLine)
    End Sub

    Private Sub SetRewritable(ByVal rewritable As SDK.Rewritable)
        EraseAreaLeftUpDown.Value = rewritable.EraseArea.Left
        EraseAreaWidthUpDown.Value = rewritable.EraseArea.Width
        EraseAreaBottomUpDown.Value = rewritable.EraseArea.Bottom
        EraseAreaHeightUpDown.Value = rewritable.EraseArea.Height
        EraseBeforePrint.Checked = rewritable.EraseBeforePrint
        ErasePowerStartUpDown.Value = rewritable.ErasePowerStart
        ErasePowerEndUpDown.Value = rewritable.ErasePowerEnd
        WritePowerUpDown.Value = rewritable.WritePower
    End Sub

    Private Sub RewritableButton_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) _
                Handles RewritableButton.Click
        Dim rewritable As New SDK.Rewritable
        Dim SDKReturn As SDK.Return

        If Driver1ActionIsGet() Then
            If GetRewritable(rewritable) = SDK.Return.Success Then
                RewritableToMsgBox(SDK.Action.Read, rewritable)
            End If
        Else
            rewritable.EraseArea = New SDK.Area
            rewritable.EraseArea.Left = EraseAreaLeftUpDown.Value
            rewritable.EraseArea.Width = EraseAreaWidthUpDown.Value
            rewritable.EraseArea.Bottom = EraseAreaBottomUpDown.Value
            rewritable.EraseArea.Height = EraseAreaHeightUpDown.Value
            rewritable.EraseBeforePrint = EraseBeforePrint.Checked
            rewritable.ErasePowerStart = ErasePowerStartUpDown.Value
            rewritable.ErasePowerEnd = ErasePowerEndUpDown.Value
            rewritable.WritePower = WritePowerUpDown.Value

            SDKReturn = SDK.ID_Rewritable(hSession, SDK.Action.Write, rewritable)
            If SDKReturn <> SDK.Return.Success Then
                HandleError("SetRewritable", SDKReturn)
            Else
                RewritableToMsgBox(SDK.Action.Write, rewritable)
            End If
        End If
    End Sub

#End Region

    '----------------------------------------------------------------------

#Region "=== Printable Areas ==="

    Private Function GetPrintableArea(ByRef Area As SDK.Area) As SDK.Return
        Dim SDKReturn As SDK.Return = SDK.ID_PrintableArea(hSession, SDK.Action.Read, Area)
        If SDKReturn = SDK.Return.Success Then
            SetPrintableArea(Area)
        Else
            HandleError("GetPrintableArea", SDKReturn)
        End If

        Return SDKReturn
    End Function

    Private Sub PrintableAreaToMsgBox(ByVal Action As SDK.Action, ByVal area As SDK.Area)
        Dim sep As String = Separator(Action)
        Driver1MsgBox.AppendText("Area Left" + sep + area.Left.ToString() + Environment.NewLine)
        Driver1MsgBox.AppendText("Area Width" + sep + area.Width.ToString() + Environment.NewLine)
        Driver1MsgBox.AppendText("Area Bottom" + sep + area.Bottom.ToString() + Environment.NewLine)
        Driver1MsgBox.AppendText("Area Height" + sep + area.Height.ToString() + Environment.NewLine)
        Driver1MsgBox.AppendText(Environment.NewLine)
    End Sub

    Private Sub SetPrintableArea(ByVal Area As SDK.Area)
        PrintableAreaLeftUpDown.Value = Area.Left
        PrintableAreaWidthUpDown.Value = Area.Width
        PrintableAreaBottomUpDown.Value = Area.Bottom
        PrintableAreaHeightUpDown.Value = Area.Height
    End Sub

    Private Sub PrintableAreaButton_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) _
                Handles PrintableAreaButton.Click
        Dim area As New SDK.Area

        If Driver1ActionIsGet() Then
            If GetPrintableArea(area) = SDK.Return.Success Then
                PrintableAreaToMsgBox(SDK.Action.Read, area)
            End If
        Else
            area.Left = PrintableAreaLeftUpDown.Value
            area.Width = PrintableAreaWidthUpDown.Value
            area.Bottom = PrintableAreaBottomUpDown.Value
            area.Height = PrintableAreaHeightUpDown.Value

            Dim SDKReturn As SDK.Return = SDK.ID_PrintableArea(hSession, _
                                                               SDK.Action.Write, _
                                                               area)
            If SDKReturn <> SDK.Return.Success Then
                HandleError("SetPrintableArea", SDKReturn)
            Else
                PrintableAreaToMsgBox(SDK.Action.Write, area)
            End If
        End If
    End Sub

#End Region

    '----------------------------------------------------------------------

#Region "=== Resolution ==="

    Private Function GetResolution(ByRef resolution As Byte) As SDK.Return
        Dim SDKReturn As SDK.Return = SDK.ID_Resolution(hSession,
                                                        SDK.Action.Read,
                                                        resolution)
        If SDKReturn = SDK.Return.Success Then
            SetResolution(resolution)
        Else
            HandleError("GetResolution", SDKReturn)
        End If

        Return SDKReturn
    End Function


    Private Sub ResolutionToMsgBox(ByVal action As SDK.Action, ByVal resolution As Byte)
        Dim msg As String = "Resolution" + Separator(action)
        If resolution <> 0 Then
            msg = msg + "600"
        Else
            msg = msg + "300"
        End If
        Driver1MsgBox.AppendText(msg + " x 300 DPI" + Environment.NewLine + Environment.NewLine)
    End Sub

    Private Sub SetResolution(ByVal resolution As Byte)
        If resolution = 0 Then
            Radio300DPI.Checked = True
        Else
            Radio600DPI.Checked = True
        End If
    End Sub


    Private Sub ResolutionButton_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) _
                Handles ResolutionButton.Click
        Dim resolution As Byte = 0

        If Driver1ActionIsGet() Then
            If GetResolution(resolution) = SDK.Return.Success Then
                ResolutionToMsgBox(SDK.Action.Read, resolution)
            End If

        Else
            If Radio600DPI.Checked Then
                resolution = 1
            End If

            Dim SDKReturn As SDK.Return = SDK.ID_Resolution(hSession,
                                                     SDK.Action.Write,
                                                     resolution)
            If SDKReturn <> SDK.Return.Success Then
                HandleError("SetResolution", SDKReturn)
            Else
                ResolutionToMsgBox(SDK.Action.Write, resolution)
            End If
        End If
    End Sub

#End Region

End Class

